<!DOCTYPE html>
<html>
<head>
	<title>An explanation of the different versions of the Law of One books</title>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
	<meta name="keywords" content="law of one, infinite creator, logos, service to others, ra, seven densities, two paths, free will, unity">
	<link rel="shortcut icon" href="f1369028838favicon.ico" type="image/x-icon">
	<link rel="apple-touch-icon-precomposed" href="f-1869899766apple-touch-icon.png">
	<link rel="stylesheet" href="f-788052878styles.css" type="text/css">
	<meta name="description" content="Explains the differences between the Book I-V version, the original version, the lightly edited version, and the relistened version of the Law of One information channeled by L/L Research in 1981-1984.">
</head>
<body>
<h2>An explanation of the different versions of the <a href="_h_.html"><i>Law of One</i></a> books</h2>
<div class="heading-list">
<h3>Versions available from L/L Research</h3>
<ul>
	<li><b><i>Books I-IV</i></b>: The versions published by L/L Research in 1982–1984.  Questions and answers, mostly personal, that were considered uninteresting to readers were withheld.  These books are available for purchase from L/L Research’s <a href="http://store.bring4th.org/index.php?cPath=21">online store</a> or for download from their <a href="http://www.llresearch.org/library/the_law_of_one_pdf/the_law_of_one_pdf.aspx">library</a>.  <i>Book I</i> contains a lengthy <a href="f611876615introduction-to-book-I.pdf">introduction</a> to the Ra sessions that explains L/L Research’s methodology and how they came to contact Ra.</li>
	<li><b><i>Book V</i></b>: Published in 1998, <i>Book V</i> contains most of the information that was withheld from <i>Books I-IV</i>, along with commentary by Jim McCarty and Carla Rueckert about the newly published material.  This book is also available for <a href="http://store.bring4th.org/product_info.php?cPath=21&products_id=33">purchase</a> or <a href="http://www.llresearch.org/library/the_law_of_one_pdf/the_law_of_one_pdf.aspx">download</a>.</li>
</ul>
<h3>Versions available from lawofone.info</h3>
<ul>
	<li><b>“Original Version”</b>: This version reintegrates the <i>Book V</i> material into the sessions from which it was originally taken.  In this version, no other changes have been made to the text published by L/L Research.</li>
	<li><b>“Relistened Version”</b>: The raw, unedited version produced by verifying the original version against <a href="http://store.bring4th.org/index.php?cPath=23">copies of the original tapes</a>.  It contains some questions and answers not previously published, and it makes numerous, mostly minor, changes to Don’s questions and occasional, not-always-so-minor changes to Ra’s answers.  Gaps in the audio are indicated by [brackets].</li>
	<li><b>“Lightly Edited Version”</b>: The relistened version, edited minimally.  It contains the answers from the relistened version, unedited except in <a href="f-545413198relistening-report.php">these places</a>.  The questions are also from the relistened version, but they have been lightly edited for legibility.  Gaps in the audio are not indicated, and the text for those gaps is as published in the original version.</li>
</ul>

<h3>Differences</h3>
<ul>
<li><a href="f2063017892show-diff.php">Relistened/Edited</a></li>
<li><a href="f2063015009show-diff.php">Original/Edited</a></li>
<li><a href="f-1701826278show-diff.php">Original/Edited (Answers Only)</a></li>
<li><a href="f2063015022show-diff.php">Original/Relistened</a></li>
<li><a href="f-1718346834show-diff.php">LLR <i>Book I</i>/“Original”</a> (Use this to see where the Book V material fit into each session)</li>
</ul>

</div>
<p style="text-align: center; margin-top: 2em;">
	<a href="_h_.html">Home</a> ∙ 
	<a href="f731037089search.php">Search</a> ∙ 
	<a href="f-1390545771categories.php">Categories</a> ∙ 
	<a href="f-1574893994sessions.php">Sessions</a> ∙ 
	<a href="f-810092595synopsis.php">Synopsis</a> ∙ 
	<a href="f774683843favorite-quotes.php">Favorite&nbsp;Quotes</a> ∙ 
	<a href="f1285527712unusual-words.php">Unusual&nbsp;Words</a> ∙ 
	<a href="f-545413198relistening-report.php">Relistening Report</a> ∙ 
	<a href="f-2042705306tips-and-tricks.php">Tips and Tricks</a> ∙ 
	<a href="f1060319237results.php">Random&nbsp;Q&nbsp;&amp;&nbsp;A</a> ∙ 
	<a href="f2040867444links.php">Links</a> ∙ 
	<a href="f-920912309excerpts.php">Excerpts</a> ∙ 
	<a href="f-991132332versions.php">Versions</a> ∙ 
	<a href="f2063015009show-diff.php">Differences</a> ∙ 
	<a href="f653172817recent-updates.php">Recent&nbsp;Updates</a> ∙ 
	<a href="f1162575527current-goals.php">Current&nbsp;Goals</a> ∙ 
	<a href="f-1376487557recent-referrers.php">Recent Referrers</a> ∙ 
	<a href="f-504967805recent-searches.php">Recent Searches</a> ∙ 
	<a href="f-2075326040images">Images</a> ∙ 
	<a href="http://www.llresearch.org/">L/L Research</a> ∙ 
	<a href="http://www.bring4th.org/">Bring4th</a> ∙ 
	<a href="f-80480438support.php">Donate</a>
</p>
<p style="text-align: center;">The <i>Law of One</i> books are copyright &copy;1982, 1984, 1998 <a href="http://www.llresearch.org/">L/L Research</a>.  This site copyright &copy;2003&ndash;2013 Tobey Wheelock.</p>
<p style="text-align: center;">Questions? Comments? Email me: tw at law of one dot info.</p>
<script src="js/scripts.js" type="text/javascript"></script>
</body>
</html>
